
import { DatabaseService } from './src/database.js';

async function initializeDatabase() {
    console.log('Initializing database...');
    
    try {
        const db = new DatabaseService();
        await db.initTables();
        console.log('Database initialization completed successfully!');
        process.exit(0);
    } catch (error) {
        console.error('Database initialization failed:', error);
        process.exit(1);
    }
}

initializeDatabase();